/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.physical.item;

import com.badlogic.gdx.graphics.Color;
import java.util.EnumMap;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.item.model.ItemPlacement;
import technology.rocketjump.undermount.assets.entities.item.model.ItemSize;
import technology.rocketjump.undermount.assets.entities.item.model.ItemStyle;
import technology.rocketjump.undermount.assets.entities.model.ColoringLayer;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.entities.model.physical.EntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemType;

public class ItemEntityAttributes
implements EntityAttributes {
    private long seed;
    private EnumMap<GameMaterialType, GameMaterial> materials = new EnumMap(GameMaterialType.class);
    private EnumMap<ColoringLayer, Color> otherColors = new EnumMap(ColoringLayer.class);
    private ItemType itemType;
    private ItemSize itemSize = ItemSize.AVERAGE;
    private ItemStyle itemStyle = ItemStyle.DEFAULT;
    private ItemPlacement itemPlacement = ItemPlacement.ON_GROUND;
    private int quantity;
    private int numAllocated;

    public ItemEntityAttributes(long seed) {
        this.seed = seed;
    }

    @Override
    public ItemEntityAttributes clone() {
        ItemEntityAttributes cloned = new ItemEntityAttributes(this.seed);
        for (Map.Entry<GameMaterialType, GameMaterial> entry : this.materials.entrySet()) {
            cloned.materials.put((GameMaterialType)((Enum)entry.getKey()), entry.getValue());
        }
        for (Map.Entry<Enum, Object> entry : this.otherColors.entrySet()) {
            cloned.otherColors.put((ColoringLayer)entry.getKey(), ((Color)entry.getValue()).cpy());
        }
        cloned.itemType = this.itemType;
        cloned.itemSize = this.itemSize;
        cloned.itemStyle = this.itemStyle;
        cloned.itemPlacement = this.itemPlacement;
        cloned.quantity = this.quantity;
        cloned.numAllocated = this.numAllocated;
        return cloned;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    @Override
    public Color getColor(ColoringLayer coloringLayer) {
        GameMaterialType materialType = coloringLayer.getLinkedMaterialType();
        if (materialType != null) {
            GameMaterial gameMaterial = this.materials.get((Object)materialType);
            if (gameMaterial != null) {
                return gameMaterial.getColor();
            }
            return null;
        }
        return this.otherColors.get((Object)coloringLayer);
    }

    public boolean canMerge(ItemEntityAttributes other) {
        if (this.itemType.equals(other.itemType) && this.itemSize.equals((Object)other.itemSize) && this.itemStyle.equals((Object)other.itemStyle)) {
            boolean materialMatch = true;
            for (GameMaterial thisMaterial : this.materials.values()) {
                if (other.materials.containsValue(thisMaterial)) continue;
                materialMatch = false;
                break;
            }
            return materialMatch;
        }
        return false;
    }

    public void setColor(ColoringLayer coloringLayer, Color color) {
        this.otherColors.put(coloringLayer, color);
    }

    public void setMaterial(GameMaterial material) {
        this.materials.put(material.getMaterialType(), material);
    }

    public GameMaterial getMaterial(GameMaterialType materialType) {
        return this.materials.get((Object)materialType);
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public void setItemType(ItemType itemType) {
        this.itemType = itemType;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public ItemSize getItemSize() {
        return this.itemSize;
    }

    public void setItemSize(ItemSize itemSize) {
        this.itemSize = itemSize;
    }

    public ItemStyle getItemStyle() {
        return this.itemStyle;
    }

    public void setItemStyle(ItemStyle itemStyle) {
        this.itemStyle = itemStyle;
    }

    public ItemPlacement getItemPlacement() {
        return this.itemPlacement;
    }

    public void setItemPlacement(ItemPlacement itemPlacement) {
        this.itemPlacement = itemPlacement;
    }

    public String toString() {
        return "ItemEntityAttributes{itemType=" + this.itemType + ", itemSize=" + (Object)((Object)this.itemSize) + ", itemStyle=" + (Object)((Object)this.itemStyle) + ", itemPlacement=" + (Object)((Object)this.itemPlacement) + ", quantity=" + this.quantity + '}';
    }

    public int getNumAllocated() {
        return this.numAllocated;
    }

    public void setNumAllocated(int numAllocated) {
        this.numAllocated = numAllocated;
    }

    public int getNumUnallocated() {
        return this.quantity - this.numAllocated;
    }
}

